<?php defined('_JEXEC') or die;
/*
 * @package     mod_uk_grid
 * @copyright   © 2020 Joomlaplates. All rights reserved.
 * @license     GNU General Public License version 3 or later; see http://www.gnu.org/licenses/gpl-3.0.txt
 */
$content_before_class       = $params->get('content_before_class');
$content_before    = $params->get('content_before');

?>
<style type="text/css">

.grid-hover img { transform: scale(1); transform-origin: 50% 50% 0px; transition: all 0.3s ease 0s; }
.grid-hover a:hover img { transform: scale(1.0); }
.grid-hover .item-image-backdrop { position: absolute; top: 0px; left: 0px; z-index: 10; width: 100%; height: 100%; background-color: rgb(0, 0, 0); visibility: hidden; opacity: 0; transition: all 0.3s ease 0s; }
.grid-hover a:hover .item-image-backdrop { visibility: visible; opacity: 0.7; }
.grid-hover .item-image-backdrop::before { content: ""; z-index: 11; display: block; width: 25px; height: 1px; background-color: rgb(255, 255, 255); position: absolute; top: 50%; left: 50%; margin-left: -12px; transition: all 0.3s ease 0s; transform: translateX(-150px); }
.grid-hover .item-image-backdrop::after { content: ""; z-index: 12; display: block; width: 1px; height: 25px; background-color: rgb(255, 255, 255); position: absolute; top: 50%; left: 50%; margin-top: -12px; transition: all 0.3s ease 0s; transform: translateY(-150px); }
.grid-hover a:hover .item-image-backdrop::before { transform: translateX(0px); }
.grid-hover a:hover .item-image-backdrop::after { transform: translateY(0px); }
</style>
<?php if ($content_before) { ?>
<div class="<?php echo $content_before_class; ?>">
<?php echo $content_before; ?>
</div>
<?php } ?>
<div uk-filter="target: .js-filter">

    <ul class="uk-subnav <?php echo $show_tags; ?>">
		<li class="uk-active" uk-filter-control><a href="#"><?php echo JText::_('MOD_UK_GRID_ALL'); ?></a></li>
		<?php foreach($tagsList['index'] as $tag => $tagClass):?>
		<li uk-filter-control="filter: .<?php echo $tagClass; ?>"><a href="#"><?php echo $tag; 'UTF-8'?></a></li>
		<?php endforeach; ?>
    </ul>


<div class="js-filter mod_uk_grid<?php echo $grid_class, $classes; ?>" data-uk-grid<?php echo $grid_params, $hm_param; ?>>
    <?php
		foreach ($items as $key => $item)
		{
			
			$tags = $tagsList['items'][$key];
			$itemClass = ' ';
			foreach ($tags as $tag) {
				$itemClass .= $tagsList['index'][$tag] .' ';
			}
		?>

    <div class="<?php echo $itemClass; ?>">
        <div class="grid-hover <?php echo $item_style; ?>">
				
			<div class="uk-inline-clip uk-transition-toggle">
				<a href="#<?php echo $item->link; ?>" uk-toggle>
				<img class="" src="<?php echo $item->img; ?>" alt="<?php echo $item->title; ?>">
				<?php if ($item->title) { ?>
					<div class="uk-transition-slide-bottom uk-position-bottom uk-overlay uk-overlay-primary uk-light">
						<h4 class="uk-margin-remove uk-text-center"><?php echo $item->title; ?></h4>
					</div>
				<?php } else { ?>
				<span class="item-image-backdrop"></span>	
				<?php } ?>	
				</a>				
			</div>
			
		</div>
		
		<?php if ($item->img) { ?>
		<!-- This is the modal -->
		<div id="<?php echo $item->link; ?>" class="uk-modal-full" uk-modal>
			<div class="uk-modal-dialog">
				<button class="uk-modal-close-full uk-close-large" type="button" uk-close></button>
				<div class="uk-grid-collapse uk-child-width-1-2@s uk-flex-middle" uk-grid>
					<div class="uk-background-cover" style="background-image: url('<?php echo $item->img; ?>');" uk-height-viewport></div>
					<div class="uk-padding-large">
						<h1><?php echo $item->title; ?></h1>
						<p><?php echo $item->content; ?></p>
					</div>
				</div>
			</div>
		</div>		
		<!-- This is the modal -->
		<?php } else { ?> 
		<!-- This is the modal -->
		<div id="<?php echo $item->link; ?>" class="uk-modal-full" uk-modal>
			<div class="uk-modal-dialog">
				<button class="uk-modal-close-full uk-close-large" type="button" uk-close></button>
				<div class="uk-grid-collapse uk-child-width-1-1@s uk-flex-middle" uk-grid uk-height-viewport>
					
					<div class="uk-padding-large text-center">
						<h1><?php echo $item->title; ?></h1>
						<p><?php echo $item->content; ?></p>
					</div>
				</div>
			</div>
		</div>		
		<!-- This is the modal -->
		<?php } ?>
		
    </div>
    <?php } ?>
</div>

















	